/*********************************************
* recommendations and precautions for transition of operation modes
**********************************************

//	--------:----------------------------------------------------------
//	Operating Mode Switching Sequence :
//	NORMAL1	--> NORMAL2 --> SLOW2 --> SLOW1
//	SLOW1 --> SLOW2 --> NORMAL2 --> NORMAL1
//	--------:----------------------------------------------------------
//*********************************************************************
// 			: Each Mode Switch Sequence
//	NORMAL1	:----------------------------------------------------------
//			: --> NORMAL1
//			: --> IDLE0(INTTBT release)		--> NORMAL1
//			: --> IDLE1(Interrupt release)	--> NORMAL1
//			: --> STOP (be woken up)			--> NORMAL1
//	NORMAL2	:----------------------------------------------------------
//			: --> NORMAL2
//			: --> IDLE2(Interrupt release)			--> NORMAL2
//			: --> STOP (be woken up)			--> NORMAL2
//	SLOW2	:----------------------------------------------------------
//			: --> SLOW2
//	SLOW1	:----------------------------------------------------------
//			: --> SLOW1
//			: --> SLEEP0(INTTBT release)	--> SLOW1
//			: --> SLEEP1(Interrupt release)	--> SLOW1
//			: --> STOP  (be woken up)		--> SLOW1
//	--------:----------------------------------------------------------
//*********************************************************************

/*********************************************************************
	external high-frequency crystal(HXtal) / external low-frequency crystal(LXtal)
	HXTAL/LXTAL use the same IO (P00/P01), only one of them can be enable
/*********************************************************************
//	HXTAL/LXTAL use the same IO (P00/P01), only one of them can be enable
/*********************************************************************
Cautions:
	1. to enable LXTAL, please set FSCTRL_FSSEL to 1 using bit operation
		// to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
		// programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
		// programming by Writer : tap Type -> on the right side of the same page of IC type option -> check 'ext low OSC'
*********************************************************************/
#ifndef __OPmode_H_
#define __OPmode_H_


//--------------------------------------------------------------------------------------------------//
#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//			|........................................................................................
//			|---------> // to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
//			|---------> // programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
//			|---------> // programming by Writer : tap Type -> on the right side of the same page of IC type option -> check 'ext low OSC'
//			.........................................................................................
//--------------------------------------------------------------------------------------------------//


//-- header guards --//


//-- ȫֱ --//


//	NORMAL1	--> NORMAL2 --> SLOW2 --> SLOW1
//	SLOW1 --> SLOW2 --> NORMAL2 --> NORMAL1
#define	iNor1		1
#define	iNor2		2
#define	iSlow2		3
#define	iSlow1		4
//#define	iSlow2_R	5	// this is determined by the program itself
//#define	iNor2_R		6	// this is determined by the program itself
//#define	iNor1_R		7	// this is determined by the program itself

#define Active_IDLE0	SYSCR2.bit.b2 = 1		// TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode
#define Active_SLEEP0	SYSCR2.bit.b2 = 1		// TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode

#define Active_IDLE1	SYSCR2.bit.b3 = 1		// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
#define Active_IDLE2	SYSCR2.bit.b3 = 1		// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
#define Active_SLEEP1	SYSCR2.bit.b3 = 1		// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode

#define Active_STOP	{	SYSCR1.bit.b5 = 1; SYSCR1.bit.b6 = 1; SYSCR1.bit.b7 = 1; }
					//	SYSCR1.bit.b5 = 1;		// OUTEN=1, output hold at STOP mode
					//							// to enter STOP mode, you must pay attention to the input pin can not be floating, or set the unuse pin as the output pin
					//							// floating the input pin will cause unknown leakage
					//	SYSCR1.bit.b6 = 1;		// RELM=1,  Level-sensitive release STOP mode
					//	SYSCR1.bit.b7 = 1;		// enter STOP mode


void OpMode_Change_to(uchar iMode);
//........................| iMode: iNor1/iNor2/iSlow2/iSlow1

void XTAL_High_Config();
void HIRC_ChangeTo_8MHz();

void INTTBT_Init_OP();
void Disable_INTTBT_OP();


#endif


















